function [Data,T_VEC,ChanDelays]=STM32F411_ADC_PLOT(skt,n,rep)
%
%function [Data,T_VEC,ChanDelays]=STM32F411_ADC_PLOT(skt,n,rep)
%
% Get Data and optionally plot from an STM32F411 board with peek poke
%  skt           : peek poke udp skt structure
%  n             : number of sample frames per plot
%  rep           : number of plots to get
%                : if rep is absent - then plot until space pressed
%                : if rep=0 then get 1 plot of data - do not plot
%                : if rep <0 then do a single shot get with no plot to the 
%                :   max allowed by the size of the dma buffer
%                : NB - this is invasive and will stop and restart aquire 
%                : It will cause a glitch for other users of the dma buffer data :(   
%                :
%  Data          : output data of last plot captured
%  T_VEC         : time vector of last frame captured - (Secs)
%  ChanDelays    : vector of dhannel delays relative to 1st channel   (Secs)
% 
% See Also STM32F411_ADC_SETUP.m
%
%   Ian Stothers Feb 2021
%
%   To Do
% Some indication of data loss because we can't keep up
% This is more likely as the sample rate * no of channels gets above 80k values/sec - (i.e data rate above 160kbytes/sec)
% If this is a problem - then consider snapshot -see rep above
% 
%
frinc=-1;
if (nargin<3) % Plot till keypress case
  frinc=0;
  rep=1;
end  
if (rep>=0)
 fr=max([rep 1]);
end 

ADC1_CAL=udpget(skt,"ADC1_CAL");
STM32F411_bitfields; % Get some bitfields
SingleShot= 0;
if (rep<0)
SingleShot= 1;
frinc=-1;
end

bpe=[1 2 4 4](1+bitand(floor(udpget(skt,"DMA2_S0_CR")/(2^13)),3));  % Bytes per element from the DMA engine  
SQR1=udpget(skt,"ADC1_SQR1");
nchan = bitand(floor(SQR1/2^20),15)+1;           % Number of Channels from the ADC engine
DMABUF_ADDR=skt.ptr(skt_find_index(skt,"ADC_DMA_Buffer"));          % DMA buffer address from the registry
msdma=skt.len(skt_find_index(skt,"ADC_DMA_Buffer"))/bpe;            % DMA buffer size in bpe lumps from the registry
FT_Clock=udpget(skt,"SystemCoreClock");                             % Read Core Clock rate from registry
T2_PSC=udpget(skt,"TIM2_PSC");                                      % Read T2 presclaer from registry
T2_ARR=udpget(skt,"TIM2_ARR");                                      % Read T2 Period (ARR) Reg from registry

DT=((T2_PSC+1.0)*(T2_ARR+1.0))/FT_Clock;
SAMP_CONST=bitand(udpget(skt,"ADC1_SMPR1"),7);
ADC_PR=bitand(ADC_PRE,udpget(skt,"ADC1_COMMON_CCR"))/ADC_PRE;
CR1=udpget(skt,"ADC1_CR1");
RES_VAL=bitand(CR1,RES*3)/RES;
G_Val =1.0; % G_Val is a frig - on left align for whatever reason the chip puts the adc result in the LSB 
if (RES_VAL==3)
 G_Val =256.0;
endif  
SampCycles=[3 15 28 56 84 112 144 480]; % lookup for SampCycles(SAMP_CONST+1)
ChanDelays=((1:nchan)-1)*((3+SampCycles(SAMP_CONST+1)+(15-2*RES_VAL))*(2+(2*(ADC_PR))))/FT_Clock;

T_VEC=((1:n)-1)*DT;
%T_VEC=ones(nchan,1)*T_VEC+((1/(((20000+6.5e6)/5e5)-floor(6.5e6/5e5)))*ChanDelays')*ones(1,size(T_VEC)(2));
T_VEC=ones(nchan,1)*T_VEC+ChanDelays'*ones(1,size(T_VEC)(2));

s_of_dma=floor(msdma/nchan)*nchan;                                  % ensure dma is shrunk to contain integer number of frames to keep channel alignment
n=n*nchan; % total number of samples to get

if (SingleShot==1)
 n=min([s_of_dma-nchan n]);
 fr=1;
 frinc=-1;
 rep=0;
 udp_bit_clear(skt,"TIM2_CR1",CEN);      % Tell TIM2 to stop
end  

while (fr>0)
 fr=fr+frinc;
 tail=(s_of_dma-(ceil(udpget(skt,"DMA2_S0_NDTR")/nchan)*nchan));
 if (SingleShot==1)
   tail=tail+nchan;
   if (tail>=s_of_dma)
    tail=tail-s_of_dma;
   end 
 end
 Data=[];
 N=0;
 while (N<n)

 ptr=(s_of_dma-(ceil(udpget(skt,"DMA2_S0_NDTR")/nchan)*nchan));
   
 if (tail>ptr)
   toget=min(s_of_dma-tail,n-N); 
   data=udppeek(skt,DMABUF_ADDR+(tail*bpe),toget*bpe);
   Data=[Data data];
   N=N+toget;
   tail=tail+toget; 
   if (tail>=s_of_dma) tail=0; end 
  end 
  if ((ptr>tail)&&(N<n)) 
   toget=min(ptr-tail,n-N); 
   data=udppeek(skt,DMABUF_ADDR+(tail*bpe),toget*bpe);
   Data=[Data data];
   N=N+toget;
   tail=tail+toget;
   end
 if(kbhit(1)==' ')
  fr=0;
 end 
endwhile
 udp_bit_set(skt,"TIM2_CR1",CEN);      % Tell TIM2 to go
 Data=udpgettconv(Data,[0 2](bpe),nchan); % 0 is uint8  2 is uint16
 Data=Data*ADC1_CAL*G_Val;
 if (rep>0)
  hold off
  plot(T_VEC',Data');
  xlabel("Time (Secs)");
  grid on;
  drawnow;
 endif
end
   

 
 


  
  
  